/* Icon Picker */

(function($) {

	$.fn.iconPicker = function( options ) {
		var options = ['elegant-icons','dashicons','dashicons']; // default font set
		var icons;
		$list = $('');
		function font_set() {
			if(options[0] == 'elegant-icons') {
				icons = [
				'arrow_up',
				'arrow_down',
				'arrow_left',
				'arrow_right',
				'arrow_left-up',
				'arrow_right-up',
				'arrow_right-down',
				'arrow_left-down',
				'arrow-up-down',
				'arrow_up-down_alt',
				'arrow_left-right_alt',
				'arrow_left-right',
				'arrow_expand_alt2',
				'arrow_expand_alt',
				'arrow_condense',
				'arrow_expand',
				'arrow_move',
				'arrow_carrot-up',
				'arrow_carrot-down',
				'arrow_carrot-left',
				'arrow_carrot-right',
				'arrow_carrot-2up',
				'arrow_carrot-2down',
				'arrow_carrot-2left',
				'arrow_carrot-2right',
				'arrow_carrot-up_alt2',
				'arrow_carrot-down_alt2',
				'arrow_carrot-left_alt2',
				'arrow_carrot-right_alt2',
				'arrow_carrot-2up_alt2',
				'arrow_carrot-2down_alt2',
				'arrow_carrot-2left_alt2',
				'arrow_carrot-2right_alt2',
				'arrow_triangle-up',
				'arrow_triangle-down',
				'arrow_triangle-left',
				'arrow_triangle-right',
				'arrow_triangle-up_alt2',
				'arrow_triangle-down_alt2',
				'arrow_triangle-left_alt2',
				'arrow_triangle-right_alt2',
				'arrow_back',
				'icon_minus-06',
				'icon_plus',
				'icon_close',
				'icon_check',
				'icon_minus_alt2',
				'icon_plus_alt2',
				'icon_close_alt2',
				'icon_check_alt2',
				'icon_zoom-out_alt',
				'icon_zoom-in_alt',
				'icon_search',
				'icon_box-empty',
				'icon_box-selected',
				'icon_minus-box',
				'icon_plus-box',
				'icon_box-checked',
				'icon_circle-empty',
				'icon_circle-slelected',
				'icon_stop_alt2',
				'icon_stop',
				'icon_pause_alt2',
				'icon_pause',
				'icon_menu',
				'icon_menu-square_alt2',
				'icon_menu-circle_alt2',
				'icon_ul',
				'icon_ol',
				'icon_adjust-horiz',
				'icon_adjust-vert',
				'icon_document_alt',
				'icon_documents_alt',
				'icon_pencil',
				'icon_pencil-edit_alt',
				'icon_pencil-edit',
				'icon_folder-alt',
				'icon_folder-open_alt',
				'icon_folder-add_alt',
				'icon_info_alt',
				'icon_error-oct_alt',
				'icon_error-circle_alt',
				'icon_error-triangle_alt',
				'icon_question_alt2',
				'icon_question',
				'icon_comment_alt',
				'icon_chat_alt',
				'icon_vol-mute_alt',
				'icon_volume-low_alt',
				'icon_volume-high_alt',
				'icon_quotations',
				'icon_quotations_alt2',
				'icon_clock_alt',
				'icon_lock_alt',
				'icon_lock-open_alt',
				'icon_key_alt',
				'icon_cloud_alt',
				'icon_cloud-upload_alt',
				'icon_cloud-download_alt',
				'icon_image',
				'icon_images',
				'icon_lightbulb_alt',
				'icon_gift_alt',
				'icon_house_alt',
				'icon_genius',
				'icon_mobile',
				'icon_tablet',
				'icon_laptop',
				'icon_desktop',
				'icon_camera_alt',
				'icon_mail_alt',
				'icon_cone_alt',
				'icon_ribbon_alt',
				'icon_bag_alt',
				'icon_creditcard',
				'icon_cart_alt',
				'icon_paperclip',
				'icon_tag_alt',
				'icon_tags_alt',
				'icon_trash_alt',
				'icon_cursor_alt',
				'icon_mic_alt',
				'icon_compass_alt',
				'icon_pin_alt',
				'icon_pushpin_alt',
				'icon_map_alt',
				'icon_drawer_alt',
				'icon_toolbox_alt',
				'icon_book_alt',
				'icon_calendar',
				'icon_film',
				'icon_table',
				'icon_contacts_alt',
				'icon_headphones',
				'icon_lifesaver',
				'icon_piechart',
				'icon_refresh',
				'icon_link_alt',
				'icon_link',
				'icon_loading',
				'icon_blocked',
				'icon_archive_alt',
				'icon_heart_alt',
				'icon_star_alt',
				'icon_star-half_alt',
				'icon_star',
				'icon_star-half',
				'icon_tools',
				'icon_tool',
				'icon_cog',
				'icon_cogs',
				'arrow_up_alt',
				'arrow_down_alt',
				'arrow_left_alt',
				'arrow_right_alt',
				'arrow_left-up_alt',
				'arrow_right-up_alt',
				'arrow_right-down_alt',
				'arrow_left-down_alt',
				'arrow_condense_alt',
				'arrow_expand_alt3',
				'arrow_carrot_up_alt',
				'arrow_carrot-down_alt',
				'arrow_carrot-left_alt',
				'arrow_carrot-right_alt',
				'arrow_carrot-2up_alt',
				'arrow_carrot-2dwnn_alt',
				'arrow_carrot-2left_alt',
				'arrow_carrot-2right_alt',
				'arrow_triangle-up_alt',
				'arrow_triangle-down_alt',
				'arrow_triangle-left_alt',
				'arrow_triangle-right_alt',
				'icon_minus_alt',
				'icon_plus_alt',
				'icon_close_alt',
				'icon_check_alt',
				'icon_zoom-out',
				'icon_zoom-in',
				'icon_stop_alt',
				'icon_menu-square_alt',
				'icon_menu-circle_alt',
				'icon_document',
				'icon_documents',
				'icon_pencil_alt',
				'icon_folder',
				'icon_folder-open',
				'icon_folder-add',
				'icon_folder_upload',
				'icon_folder_download',
				'icon_info',
				'icon_error-circle',
				'icon_error-oct',
				'icon_error-triangle',
				'icon_question_alt',
				'icon_comment',
				'icon_chat',
				'icon_vol-mute',
				'icon_volume-low',
				'icon_volume-high',
				'icon_quotations_alt',
				'icon_clock',
				'icon_lock',
				'icon_lock-open',
				'icon_key',
				'icon_cloud',
				'icon_cloud-upload',
				'icon_cloud-download',
				'icon_lightbulb',
				'icon_gift',
				'icon_house',
				'icon_camera',
				'icon_mail',
				'icon_cone',
				'icon_ribbon',
				'icon_bag',
				'icon_cart',
				'icon_tag',
				'icon_tags',
				'icon_trash',
				'icon_cursor',
				'icon_mic',
				'icon_compass',
				'icon_pin',
				'icon_pushpin',
				'icon_map',
				'icon_drawer',
				'icon_toolbox',
				'icon_book',
				'icon_contacts',
				'icon_archive',
				'icon_heart',
				'icon_profile',
				'icon_group',
				'icon_grid-2x2',
				'icon_grid-3x3',
				'icon_music',
				'icon_pause_alt',
				'icon_phone',
				'icon_upload',
				'icon_download',
				'social_facebook',
				'social_twitter',
				'social_pinterest',
				'social_googleplus',
				'social_tumblr',
				'social_tumbleupon',
				'social_wordpress',
				'social_instagram',
				'social_dribbble',
				'social_vimeo',
				'social_linkedin',
				'social_rss',
				'social_deviantart',
				'social_share',
				'social_myspace',
				'social_skype',
				'social_youtube',
				'social_picassa',
				'social_googledrive',
				'social_flickr',
				'social_blogger',
				'social_spotify',
				'social_delicious',
				'social_facebook_circle',
				'social_twitter_circle',
				'social_pinterest_circle',
				'social_googleplus_circle',
				'social_tumblr_circle',
				'social_stumbleupon_circle',
				'social_wordpress_circle',
				'social_instagram_circle',
				'social_dribbble_circle',
				'social_vimeo_circle',
				'social_linkedin_circle',
				'social_rss_circle',
				'social_deviantart_circle',
				'social_share_circle',
				'social_myspace_circle',
				'social_skype_circle',
				'social_youtube_circle',
				'social_picassa_circle',
				'social_googledrive_alt2',
				'social_flickr_circle',
				'social_blogger_circle',
				'social_spotify_circle',
				'social_delicious_circle',
				'social_facebook_square',
				'social_twitter_square',
				'social_pinterest_square',
				'social_googleplus_square',
				'social_tumblr_square',
				'social_stumbleupon_square',
				'social_wordpress_square',
				'social_instagram_square',
				'social_dribbble_square',
				'social_vimeo_square',
				'social_linkedin_square',
				'social_rss_square',
				'social_deviantart_square',
				'social_share_square',
				'social_myspace_square',
				'social_skype_square',
				'social_youtube_square',
				'social_picassa_square',
				'social_googledrive_square',
				'social_flickr_square',
				'social_blogger_square',
				'social_spotify_square',
				'social_delicious_square',
				'icon_printer',
				'icon_calulator',
				'icon_building',
				'icon_floppy',
				'icon_drive',
				'icon_search-2',
				'icon_id',
				'icon_id-2',
				'icon_puzzle',
				'icon_like',
				'icon_dislike',
				'icon_mug',
				'icon_currency',
				'icon_wallet',
				'icon_pens',
				'icon_easel',
				'icon_flowchart',
				'icon_datareport',
				'icon_briefcase',
				'icon_shield',
				'icon_percent',
				'icon_globe',
				'icon_globe-2',
				'icon_target',
				'icon_hourglass',
				'icon_balance',
				'icon_rook',
				'icon_printer-alt',
				'icon_calculator_alt',
				'icon_building_alt',
				'icon_floppy_alt',
				'icon_drive_alt',
				'icon_search_alt',
				'icon_id_alt',
				'icon_id-2_alt',
				'icon_puzzle_alt',
				'icon_like_alt',
				'icon_dislike_alt',
				'icon_mug_alt',
				'icon_currency_alt',
				'icon_wallet_alt',
				'icon_pens_alt',
				'icon_easel_alt',
				'icon_flowchart_alt',
				'icon_datareport_alt',
				'icon_briefcase_alt',
				'icon_shield_alt',
				'icon_percent_alt',
				'icon_globe_alt',
				'icon_clipboard'
				];
				options[1] = 'elegant-icons';
			}
			else if (options[0] == 'dashicons') {
				icons = [
					"blank",	// there is no "blank" but we need the option
					"menu",
					"admin-site",
					"dashboard",
					"admin-media",
					"admin-page",
					"admin-comments",
					"admin-appearance",
					"admin-plugins",
					"admin-users",
					"admin-tools",
					"admin-settings",
					"admin-network",
					"admin-generic",
					"admin-home",
					"admin-collapse",
					"admin-links",
					"format-links",
					"admin-post",
					"format-standard",
					"format-image",
					"format-gallery",
					"format-audio",
					"format-video",
					"format-chat",
					"format-status",
					"format-aside",
					"format-quote",
					"welcome-write-blog",
					"welcome-edit-page",
					"welcome-add-page",
					"welcome-view-site",
					"welcome-widgets-menus",
					"welcome-comments",
					"welcome-learn-more",
					"image-crop",
					"image-rotate-left",
					"image-rotate-right",
					"image-flip-vertical",
					"image-flip-horizontal",
					"undo",
					"redo",
					"editor-bold",
					"editor-italic",
					"editor-ul",
					"editor-ol",
					"editor-quote",
					"editor-alignleft",
					"editor-aligncenter",
					"editor-alignright",
					"editor-insertmore",
					"editor-spellcheck",
					"editor-distractionfree",
					"editor-kitchensink",
					"editor-underline",
					"editor-justify",
					"editor-textcolor",
					"editor-paste-word",
					"editor-paste-text",
					"editor-removeformatting",
					"editor-video",
					"editor-customchar",
					"editor-outdent",
					"editor-indent",
					"editor-help",
					"editor-strikethrough",
					"editor-unlink",
					"editor-rtl",
					"align-left",
					"align-right",
					"align-center",
					"align-none",
					"lock",
					"calendar",
					"visibility",
					"post-status",
					"post-trash",
					"edit",
					"trash",
					"arrow-up",
					"arrow-down",
					"arrow-left",
					"arrow-right",
					"arrow-up-alt",
					"arrow-down-alt",
					"arrow-left-alt",
					"arrow-right-alt",
					"arrow-up-alt2",
					"arrow-down-alt2",
					"arrow-left-alt2",
					"arrow-right-alt2",
					"leftright",
					"sort",
					"list-view",
					"exerpt-view",
					"share",
					"share1",
					"share-alt",
					"share-alt2",
					"twitter",
					"rss",
					"facebook",
					"facebook-alt",
					"networking",
					"googleplus",
					"hammer",
					"art",
					"migrate",
					"performance",
					"wordpress",
					"wordpress-alt",
					"pressthis",
					"update",
					"screenoptions",
					"info",
					"cart",
					"feedback",
					"cloud",
					"translation",
					"tag",
					"category",
					"yes",
					"no",
					"no-alt",
					"plus",
					"minus",
					"dismiss",
					"marker",
					"star-filled",
					"star-half",
					"star-empty",
					"flag",
					"location",
					"location-alt",
					"camera",
					"images-alt",
					"images-alt2",
					"video-alt",
					"video-alt2",
					"video-alt3",
					"vault",
					"shield",
					"shield-alt",
					"search",
					"slides",
					"analytics",
					"chart-pie",
					"chart-bar",
					"chart-line",
					"chart-area",
					"groups",
					"businessman",
					"id",
					"id-alt",
					"products",
					"awards",
					"forms",
					"portfolio",
					"book",
					"book-alt",
					"download",
					"upload",
					"backup",
					"lightbulb",
					"smiley"
					]; 
					options[1] = 'dashicons';
				} else if (options[0] == 'fa') {
					icons = [
					"blank",
				// Mail
				"inbox",
				"envelope",
				"envelope-o",
				"paperclip",
				"reply-all",
				"mail-reply-all",
				"mail-forward",
				"mail-reply",
				"reply",
				// Media
				"music",
				"film",
				"step-backward",
				"fast-backward",
				"backward",
				"play",
				"play-circle",
				"play-circle-o",
				"pause",
				"stop",
				"forward",
				"fast-forward",
				"step-forward",
				"eject",			
				"repeat",
				"refresh",
				"random",			
				"headphones",
				"volume-off",
				"volume-down",
				"volume-up",
				// Arrows
				"angle-double-left",
				"angle-double-right",
				"angle-double-up",
				"angle-double-down",
				"angle-left",
				"angle-right",
				"angle-up",
				"angle-down",
				"arrows",
				"arrow-left",
				"arrow-right",
				"arrow-up",
				"arrow-down",
				"arrows-alt",
				"arrows-v",
				"arrows-h",
				"arrow-circle-left",
				"arrow-circle-right",
				"arrow-circle-up",
				"arrow-circle-down",
				"arrow-circle-o-down",
				"arrow-circle-o-up",
				"arrow-circle-o-right",
				"arrow-circle-o-left",
				"caret-down",
				"caret-up",
				"caret-left",
				"caret-right",
				"chevron-left",
				"chevron-right",
				"chevron-up",
				"chevron-down",
				"chevron-circle-left",
				"chevron-circle-right",
				"chevron-circle-up",
				"chevron-circle-down",
				"expand",
				"compress",
				"hand-o-right",
				"hand-o-left",
				"hand-o-up",
				"hand-o-down",
				"level-up",
				"level-down",
				"long-arrow-down",
				"long-arrow-up",
				"long-arrow-left",
				"long-arrow-right",
				"rotate-right",
				"toggle-left",
				"toggle-down",
				"toggle-up",
				"toggle-right",
				// Search
				"search",
				"search-plus",
				"search-minus",
				// File Editing
				"cut",
				"crop",
				"copy",
				"paste",
				"font",
				"bold",
				"italic",
				"anchor",
				"link",
				"unlink",
				"chain-broken",
				"external-link",
				"external-link-square",
				"text-height",
				"text-width",
				"align-left",
				"align-center",
				"align-right",
				"align-justify",
				"list",
				"quote-left",
				"quote-right",
				"outdent",
				"indent",
				"undo",
				"adjust",
				"tint",
				"edit",
				"list-ul",
				"list-ol",
				"list-alt",
				"th-large",
				"th",
				"th-list",
				"strikethrough",
				"underline",
				"magic",	
				"superscript",
				"subscript",
				"eraser",			
				"pagelines",					
				// Punctuation
				"asterisk",
				"question",
				"info",
				"exclamation",
				// Emoticons
				"smile-o",
				"frown-o",
				"meh-o",
				// Math + Geometry
				"check",
				"times",
				"plus",
				"minus",
				"crosshairs",
				"spinner",
				"circle",
				"circle-o",
				"dot-circle-o",
				"minus-circle",
				"times-circle",
				"check-circle",
				"exclamation-circle",
				"question-circle",
				"info-circle",
				"plus-circle",
				"plus-square",
				"plus-square-o",
				"square",
				"square-o",
				"h-square",
				"share-square",
				"share-square-o",
				"check-square-o",
				"times-circle-o",
				"check-circle-o",
				"ellipsis-h",
				"ellipsis-v",
				"minus-square",
				"check-square",
				"bullseye",
				// Rate
				"thumbs-o-up",
				"thumbs-o-down",
				"star",
				"star-o",
				"star-half",
				"star-half-o",
				"heart",
				"heart-o",
				"lemon-o",
				"trophy",
				"thumbs-up",
				"thumbs-down",			
				// Accounts
				"user",
				"user-md",
				"group",
				"sign-in",			
				"sign-out",
				"key",
				"lock",
				"unlock",
				"unlock-alt",
				"gear",
				"gears",
				"ban",			
				"female",
				"male",	
				"comment",
				"comments",
				"ticket",
				"tasks",
				"calendar",
				"calendar-o",
				// Time
				"sun-o",
				"moon-o",
				"clock-o",			
				// Site	
				"home",	
				"comment-o",
				"comments-o",
				"sitemap",
				// File Operations
				"upload",
				"download",
				"exchange",
				"file-o",
				"files-o",	
				"file",
				"file-text",
				"file-text-o",		
				"folder",
				"folder-o",
				"folder-open",			
				"hdd-o",
				"cloud",
				"cloud-download",
				"cloud-upload",	
				"save",	
				"trash-o",	
				"print",	
				// Social Networks
				"adn",
				"dribbble",
				"dropbox",
				"facebook",
				"facebook-square",
				"flickr",
				"foursquare",
				"github",
				"github-square",
				"github-alt",
				"gittip",
				"google-plus",
				"google-plus-square",
				"instagram",
				"linkedin",
				"linkedin-square",
				"pinterest",
				"pinterest-square",
				"renren",
				"rss",
				"rss-square",
				"skype",
				"stack-exchange",
				"stack-overflow",
				"trello",
				"tumblr",
				"tumblr-square",
				"twitter",
				"twitter-square",
				"retweet",
				"vimeo-square",
				"vk",
				"weibo",
				"xing",
				"xing-square",
				"youtube",
				"youtube-square",
				"youtube-play",
				// Computer			
				"desktop",
				"laptop",
				"tablet",
				"mobile-phone",			
				"phone",			
				"phone-square",		
				"microphone",
				"microphone-slash",	
				"apple",
				"windows",
				"android",
				"linux",
				"html5",
				"css3",			
				"gamepad",
				"keyboard-o",						
				"signal",
				"power-off",
				"terminal",
				"code",			
				"code-fork",
				"bug",
				// Maps
				"glass",
				"globe",
				"map-marker",
				"thumb-tack",
				"building-o",
				"hospital-o",
				"location-arrow",
				"compass",
				"road",			
				// Tools & Objects
				"bell",
				"book",
				"bookmark",
				"bookmark-o",
				"bullhorn",
				"camera",
				"camera-retro",
				"video-camera",
				"picture-o",
				"pencil",
				"pencil-square",
				"flask",			
				"briefcase",
				"table",
				"truck",
				"wrench",
				"plane",			
				"lightbulb-o",			
				"stethoscope",
				"suitcase",
				"bell-o",
				"coffee",			
				"cutlery",
				"umbrella",
				"ambulance",
				"medkit",
				"fighter-jet",
				"beer",
				"wheelchair",		
				"gift",
				"leaf",
				"fire",
				"eye",
				"eye-slash",
				"warning",
				"magnet",
				"flag",
				"flag-o",
				"flag-checkered",
				"fire-extinguisher",
				"rocket",
				"shield",
				"puzzle-piece",
				"legal",
				"dashboard",
				"flash",						
				"bars",
				"bar-chart-o",
				// Sorting
				"columns",
				"filter",
				"sort",
				"sort-down",
				"sort-up",
				"sort-alpha-asc",
				"sort-alpha-desc",
				"sort-amount-asc",
				"sort-amount-desc",
				"sort-numeric-asc",
				"sort-numeric-desc",
				// e-Commerce
				"money",
				"certificate",
				"credit-card",
				"shopping-cart",
				"euro",
				"gbp",
				"dollar",
				"rupee",
				"yen",
				"ruble",
				"won",
				"bitcoin",
				"bitbucket-square",
				"turkish-lira",	
				"tag",
				"tags",
				"qrcode",
				"barcode"
				];
				options[1] = "fa";
			} else {
				icons = [
				"blank",
				"standard",
				"aside",
				"image",
				"gallery",
				"video",
				"status",
				"quote",
				"link",
				"chat",
				"audio",

				/* Social icons */
				"github",
				"dribbble",
				"twitter",
				"facebook",
				"facebook-alt",
				"wordpress",
				"googleplus",
				"linkedin",
				"linkedin-alt",
				"pinterest",
				"pinterest-alt",
				"flickr",
				"vimeo",
				"youtube",
				"tumblr",
				"instagram",
				"codepen",
				"polldaddy",
				"googleplus-alt",
				"path",
				"skype",
				"digg",
				"reddit",
				"stumbleupon",
				"pocket",

				/* Meta icons */
				"comment",
				"category",
				"tag",
				"time",
				"user",
				"day",
				"week",
				"month",
				"pinned",

				/* Other icons */
				"search",
				"unzoom",
				"zoom",
				"show",
				"hide",
				"close",
				"close-alt",
				"trash",
				"star",
				"home",
				"mail",
				"edit",
				"reply",
				"feed",
				"warning",
				"share",
				"attachment",
				"location",
				"checkmark",
				"menu",
				"refresh",
				"minimize",
				"maximize",
				"404",
				"spam",
				"summary",
				"cloud",
				"key",
				"dot",
				"next",
				"previous",
				"expand",
				"collapse",
				"dropdown",
				"dropdown-left",
				"top",
				"draggable",
				"phone",
				"send-to-phone",
				"plugin",
				"cloud-download",
				"cloud-upload",
				"external",
				"document",
				"book",
				"cog",
				"unapprove",
				"cart",
				"pause",
				"stop",
				"skip-back",
				"skip-ahead",
				"play",
				"tablet",
				"send-to-tablet",
				"info",
				"notice",
				"help",
				"fastforward",
				"rewind",
				"portfolio",
				"heart",
				"code",
				"subscribe",
				"unsubscribe",
				"subscribed",
				"reply-alt",
				"reply-single",
				"flag",
				"print",
				"lock",
				"bold",
				"italic",
				"picture",

				/* Generic shapes */
				"uparrow",
				"rightarrow",
				"downarrow",
				"leftarrow"
				];
				options[1] = 'genericon';
			};
		};
		font_set();

		function build_list($popup,$button,clear) {
			$list = $popup.find('.icon-picker-list');
	  if (clear==1) { $list.empty(); // clear list //
	  }
	  for (var i in icons) {
	  	$list.append('<li data-icon="'+icons[i]+'"><a href="#" title="'+icons[i]+'"><span class="'+options[0]+' '+options[1]+'-'+icons[i]+'"></span></a></li>');
	  };
	  $('a', $list).click(function(e) {
	  	e.preventDefault();
	  	var title = $(this).attr("title");
	  	$target.val(options[0]+"|"+options[1]+"-"+title);
	  	$button.removeClass().addClass("button icon-picker "+options[0]+" "+options[1]+"-"+title);
	  	removePopup();
	  });
	};
	
	function removePopup(){
		$(".icon-picker-container").remove();
	}
	

	$button = $('.icon-picker');
	$button.each( function() {
		$(this).on('click.iconPicker', function() {
			createPopup($(this));
		});
	});


	function createPopup($button) {
		$target = $($button.data('target'));
		$popup = $('<div class="icon-picker-container"> \
			<div class="icon-picker-control" /> \
			<ul class="icon-picker-list" /> \
			</div>')
		.css({
			'top': $button.offset().top,
			'left': $button.offset().left
		});
		build_list($popup,$button,0);
		var $control = $popup.find('.icon-picker-control');
		$control.html('<p>Select Font: <select><option value="elegant-icons">Elegant Icons</option><option value="dashicons">Dashicons</option><option value="fa">Font Awesome</option><option value="genericon">Genericons</option></select></p>'+
			'<a data-direction="back" href="#"><span class="dashicons dashicons-arrow-left-alt2"></span></a> '+
			'<input type="text" class="" placeholder="Search" />'+
			'<a data-direction="forward" href="#"><span class="dashicons dashicons-arrow-right-alt2"></span></a>'+
			'');

		$('select', $control).on('change', function(e) {
			e.preventDefault();
			if (this.value != options[0]) {
				options[0] = this.value;
				font_set();
				build_list($popup,$button,1);
			};
		});

		$('a', $control).click(function(e) {
			e.preventDefault();
			if ($(this).data('direction') === 'back') {
						//move last 25 elements to front
						$('li:gt(' + (icons.length - 26) + ')', $list).each(function() {
							$(this).prependTo($list);
						});
					} else {
						//move first 25 elements to the end
						$('li:lt(25)', $list).each(function() {
							$(this).appendTo($list);
						});
					}
				});

		$popup.appendTo('body').show();

		$('input', $control).on('keyup', function(e) {
			var search = $(this).val();
			if (search === '') {
						//show all again
						$('li:lt(25)', $list).show();
					} else {
						$('li', $list).each(function() {
							if ($(this).data('icon').toString().toLowerCase().indexOf(search.toLowerCase()) !== -1) {
								$(this).show();
							} else {
								$(this).hide();
							}
						});
					}
				});



		$(document).mouseup(function (e){
			if (!$popup.is(e.target) && $popup.has(e.target).length === 0) {
				removePopup();
			}
		});
	}
}


$(function() {
	$('.icon-picker').iconPicker();
});

}(jQuery));
