<?php 
global $wpdb;
$footerBlobArray = [];
$sfsFooters = get_posts([
	"post_type" 	=> 'sfs-footer',
	"post_status" 	=> 'publish',
	"posts_per_page"=>  -1
]);
foreach($sfsFooters as $sfsFooter) {
	$footerMeta = get_post_meta($sfsFooter->ID);
	$footerBlobArray[] = [
	"post_title"	=> $sfsFooter->post_title,
	"post_content"	=> $sfsFooter->post_content,
	"meta"			=> $footerMeta
	];
}
$rawDemos = @unserialize(@base64_decode(@file_get_contents(SFS_PATH.'demos/all-demos.sfsbackup')));
//echo '<pre>',print_r($rawDemos, 0),'</pre>';
?>
<script>
	var sfsExport 		= '<?php echo base64_encode(serialize($footerBlobArray)); ?>';
	var sfsRawDemos = [];
	<?php foreach($rawDemos as $rawDemo): ?>
	sfsRawDemos.push('<?php echo @base64_encode(@serialize([$rawDemo])) ?>');
	<?php endforeach; ?>
</script>
<table class="form-table sfs-table sfs-table-full" id="sfs-import-export">
	<tbody>
		<tr>
			<th>
				<label data-hint="<?php echo __("If you need you can import a previously .sfsbackup generated by export option.", "smart-footer-system"); ?>"><?php echo __("Import", "smart-footer-system") ?></label>
			</th>
			<td>
				<section id="sfs-import">
					<form action="javascript:;">
						<input id="sfs-import-file" type="file" name="import-file">
						<a id="a-import" href="javascript:;" type="button" class="button button-default button-large"><?php echo __('Import','smart-footer-system') ?></a>
					</form>
					<div class="sfs-imported">
						<div class="imported">
							<span></span> <?php echo __("footers imported!", 'smart-footer-system') ?>
						</div>
						<div class="errors">
							<span></span> <?php echo __("errors", 'smart-footer-system') ?>
						</div>
					</div>						
				</section>
			</td>
		</tr>
		<tr>
			<th>
				<label data-hint="<?php echo __("Use this option to generate a .sfsbackup file that save all data of your footers.", "smart-footer-system"); ?>"><?php echo __("Export", "smart-footer-system") ?></label>
			</th>
			<td>
				<section id="sfs-export">
					<form action="javascript:;">
						<a download="sfs-export-<?php echo date("Y-m-d-h-i"); ?>.sfsbackup" id="a-export" href="javascript:;" type="button" class="button button-default button-large"><?php echo __('Export all footers','smart-footer-system') ?></a>
					</form>
				</section>	
			</td>
		</tr>
		<tr>
			<th>
				<label data-hint="<?php echo __("Import demos that you seen on official Smart Footer System Website", "smart-footer-system"); ?>"><?php echo __("Import Demos", "smart-footer-system") ?></label>
			</th>
			<td>
				<section id="sfs-import-demo">
					<form action="javascript:;">
						<a id="sfs-import-demo-a" href="javascript:;" type="button" class="button button-default button-large"><?php echo __('Import Demos','smart-footer-system') ?></a>
						<textarea id="sfs-import-demo-textarea" style="display: none" name="" id="" cols="30" rows="10"></textarea>
					</form>
				</section>	
			</td>
		</tr>				
	</tbody>
</table>
<div id="sfs-import-loading">
	<div class="sfs-import-loading-content">
		<h2><?php echo __("Import Smart Footer System demos...", "smart-footer-system")  ?></h2>
		<span class="loading-bar">
			<i></i>
			<b>10/<?php echo count($rawDemos) ?></b>
		</span>
		<span class="loading-message loading-message-ok"><?php echo __("DONE!"); ?></span>
	</div>
</div>